﻿#pragma once

#if       !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)
#include  <szArchiveOpenClientCallback.hpp>
#endif // !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)

#if       !defined(INCLUDED_SZ_ARCHIVE_FILE_UPDATE_CLIENT_CALLBACK)
#include  <szArchiveFileUpdateClientCallback.hpp>
#endif // !defined(INCLUDED_SZ_ARCHIVE_FILE_UPDATE_CLIENT_CALLBACK)

#if       !defined(INCLUDED_SZ_GET_PASSWORD_CLIENT_CALLBACK)
#include  <szGetPasswordClientCallback.hpp>
#endif // !defined(INCLUDED_SZ_GET_PASSWORD_CLIENT_CALLBACK)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

SZ_NS_BEG(szpp)

struct ArchiveUpdaterOptions;

SZ_NS_END(szpp)

class CommandProcessorState;
class ProcessUI;

class Compressor :
  public szpp::ArchiveOpenClientCallback,
  public szpp::ArchiveFileUpdateClientCallback,
  public szpp::GetPasswordClientCallback
{
public:

  Compressor(const std::vector<szstring> &files, const szstring &archivePath, szpp::ArchiveUpdaterOptions *options, CommandProcessorState *pState, ProcessUI *pUI);
  ~Compressor();

  /// 圧縮の準備をする。続行できないエラーが起きれば例外を送出。
  void Prepare();

  /// SevenZip++ の簡易圧縮機能を使って展開する。
  void Compress();

  HRESULT RecordError(const szstring &name, u32 systemError);

  // ArchiveOpenClientCallback
  virtual HRESULT SetTotal(const u64 &files, const u64 &bytes);
  virtual HRESULT SetCompleted(const u64 &files, const u64 &bytes);

  // GetPasswordClientCallback
  virtual HRESULT GetPassword(szstring *password);

  // ArchiveFileUpdateClientCallback
  virtual HRESULT SetTotal(const u64 &size);
  virtual HRESULT SetCompleted(const u64 &completeValue);
  virtual HRESULT SetRatioInfo(const u64 &inSize, const u64 &outSize);
  virtual HRESULT CheckBreak();
  virtual HRESULT Finalize();
  virtual HRESULT SetNumFiles(const u64 &numFiles);
  virtual HRESULT GetStream(const szstring &name, bool isAnti);
  virtual HRESULT OpenFileError(const szstring &name, u32 systemError);
  virtual HRESULT SetOperationResult(u32 operationResult);
  virtual HRESULT CryptoGetTextPassword2(u32 *passwordIsDefined, szstring *password);
  virtual HRESULT CryptoGetTextPassword(szstring *password);
  virtual HRESULT OpenResult(const szstring &name, HRESULT result);
  virtual HRESULT StartScanning();
  virtual HRESULT ScanProgress(const u64 &numFolders, const u64 &numFiles, const szstring &path);
  virtual HRESULT CanNotFindError(const szstring &name, u32 systemError);
  virtual HRESULT FinishScanning();
  virtual HRESULT StartArchive(const szstring &name, bool updating);
  virtual HRESULT FinishArchive();

private:

  void CompressGzip(const szstring &srcPath, const szstring &dstPath);
  void CompressBzip2(const szstring &srcPath, const szstring &dstPath);
  void ProcessTar();

  HRESULT CheckQuitAndReturn();
  void ThrowIfCanceled();
  
  const std::vector<szstring> &files;
  szstring archivePath;
  szpp::ArchiveUpdaterOptions *pOptions;
  CommandProcessorState *pState;
  ProcessUI *pUI;
  bool canceled;
  bool skipAll;
};
